<?php

use Phinx\Migration\AbstractMigration;

class Initial extends AbstractMigration
{

    public $autoId = false;

    public function up()
    {
        $table = $this->table('activities', array( 'id' => false, 'primary_key' => 'id' ));
        $table
        ->addColumn('id', 'integer', array(
            'identity' => true,
            'default'  => null,
            'limit'    => 10,
            'null'     => false,
            'signed'   => false,
        ))
        ->addColumn('user_id', 'integer', array(
            'default' => null,
            'limit'   => 10,
            'null'    => false,
            'signed'  => false,
        ))
        ->addColumn('type', 'string', array(
            'comment' => 'Controller',
            'default' => null,
            'limit'   => 256,
            'null'    => false,
        ))
        ->addColumn('action', 'string', array(
            'comment' => 'Action',
            'default' => null,
            'limit'   => 256,
            'null'    => false,
        ))
        ->addColumn('message', 'string', array(
            'default' => null,
            'limit'   => 256,
            'null'    => false,
        ))
        ->addColumn('ip', 'string', array(
            'default' => null,
            'limit'   => 256,
            'null'    => false,
        ))
        ->addColumn('created', 'datetime', array(
            'default' => null,
            'limit'   => null,
            'null'    => false,
        ))
        ->addIndex(
            array(
            'user_id',
            )
        )
        ->create();

        $table = $this->table('ads', array( 'id' => false, 'primary_key' => 'id' ));
        $table
        ->addColumn('id', 'integer', array(
            'identity' => true,
            'default'  => null,
            'limit'    => 10,
            'null'     => false,
            'signed'   => false,
        ))
        ->addColumn('type', 'string', array(
            'comment' => '\'Interstitial Adverts\',\'Banner Adverts\'',
            'default' => null,
            'limit'   => 256,
            'null'    => false,
        ))
        ->create();

        $table = $this->table('bundles', array( 'id' => false, 'primary_key' => 'id' ));
        $table
        ->addColumn('id', 'integer', array(
            'identity' => true,
            'default'  => null,
            'limit'    => 10,
            'null'     => false,
            'signed'   => false,
        ))
        ->addColumn('user_id', 'integer', array(
            'default' => null,
            'limit'   => 10,
            'null'    => false,
            'signed'  => false,
        ))
        ->addColumn('user_bundle_id', 'integer', array(
            'default' => null,
            'limit'   => 10,
            'null'    => false,
            'signed'  => false,
        ))
        ->addColumn('name', 'string', array(
            'default' => null,
            'limit'   => 256,
            'null'    => false,
        ))
        ->addColumn('private', 'boolean', array(
            'default' => null,
            'limit'   => null,
            'null'    => false,
        ))
        ->addColumn('description', 'text', array(
            'default' => null,
            'limit'   => null,
            'null'    => false,
        ))
        ->addColumn('views', 'integer', array(
            'default' => null,
            'limit'   => 10,
            'null'    => false,
            'signed'  => false,
        ))
        ->addColumn('updated', 'datetime', array(
            'default' => null,
            'limit'   => null,
            'null'    => false,
        ))
        ->addColumn('created', 'datetime', array(
            'default' => null,
            'limit'   => null,
            'null'    => false,
        ))
        ->addIndex(
            array(
            'user_id',
            )
        )
        ->create();

        $table = $this->table('links', array( 'id' => false, 'primary_key' => 'id' ));
        $table
        ->addColumn('id', 'integer', array(
            'identity' => true,
            'default'  => null,
            'limit'    => 10,
            'null'     => false,
            'signed'   => false,
        ))
        ->addColumn('user_id', 'integer', array(
            'default' => null,
            'limit'   => 10,
            'null'    => false,
            'signed'  => false,
        ))
        ->addColumn('long_url', 'string', array(
            'default' => null,
            'limit'   => 2000,
            'null'    => false,
        ))
        ->addColumn('alias', 'string', array(
            'default' => null,
            'limit'   => 50,
            'null'    => false,
        ))
        ->addColumn('password', 'string', array(
            'default' => null,
            'limit'   => 70,
            'null'    => false,
        ))
        ->addColumn('bundle_id', 'integer', array(
            'default' => null,
            'limit'   => 10,
            'null'    => false,
            'signed'  => false,
        ))
        ->addColumn('redirection_type', 'integer', array(
            'comment' => '0 default, 1 direct, 2 Cutom',
            'default' => null,
            'limit'   => 2,
            'null'    => false,
            'signed'  => false,
        ))
        ->addColumn('title', 'string', array(
            'default' => null,
            'limit'   => 256,
            'null'    => false,
        ))
        ->addColumn('description', 'text', array(
            'default' => null,
            'limit'   => null,
            'null'    => false,
        ))
        ->addColumn('image', 'string', array(
            'default' => null,
            'limit'   => 256,
            'null'    => false,
        ))
        ->addColumn('timer', 'integer', array(
            'default' => null,
            'limit'   => 10,
            'null'    => true,
        ))
        ->addColumn('clicks', 'integer', array(
            'default' => null,
            'limit'   => 10,
            'null'    => false,
            'signed'  => false,
        ))
        ->addColumn('ip', 'string', array(
            'default' => null,
            'limit'   => 256,
            'null'    => false,
        ))
        ->addColumn('updated', 'datetime', array(
            'default' => null,
            'limit'   => null,
            'null'    => false,
        ))
        ->addColumn('created', 'datetime', array(
            'default' => null,
            'limit'   => null,
            'null'    => false,
        ))
        ->addIndex(
            array(
            'user_id',
            )
        )
        ->create();

        $table_prefix = $table->getAdapter()->getOption('table_prefix');

        $this->execute('ALTER TABLE `' . $table_prefix . 'links` CHANGE `alias` `alias` VARCHAR(50) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL;');


        $table = $this->table('options', array( 'id' => false, 'primary_key' => 'id' ));
        $table
        ->addColumn('id', 'integer', array(
            'identity' => true,
            'default'  => null,
            'limit'    => 20,
            'null'     => false,
            'signed'   => false,
        ))
        ->addColumn('option_name', 'string', array(
            'default' => null,
            'limit'   => 256,
            'null'    => false,
        ))
        ->addColumn('option_value', 'text', array(
            'default' => null,
            'limit'   => null,
            'null'    => false,
        ))
        ->create();

        $table = $this->table('pages', array( 'id' => false, 'primary_key' => 'id' ));
        $table
        ->addColumn('id', 'integer', array(
            'identity' => true,
            'default'  => null,
            'limit'    => 10,
            'null'     => false,
            'signed'   => false,
        ))
        ->addColumn('title', 'string', array(
            'default' => null,
            'limit'   => 256,
            'null'    => false,
        ))
        ->addColumn('slug', 'string', array(
            'default' => null,
            'limit'   => 256,
            'null'    => false,
        ))
        ->addColumn('published', 'integer', array(
            'default' => null,
            'limit'   => 2,
            'null'    => false,
        ))
        ->addColumn('content', 'text', array(
            'default' => null,
            'limit'   => null,
            'null'    => false,
        ))
        ->addColumn('updated', 'datetime', array(
            'default' => null,
            'limit'   => null,
            'null'    => false,
        ))
        ->addColumn('created', 'datetime', array(
            'default' => null,
            'limit'   => null,
            'null'    => false,
        ))
        ->create();

        $table = $this->table('plans', array( 'id' => false, 'primary_key' => 'id' ));
        $table
        ->addColumn('id', 'integer', array(
            'identity' => true,
            'default'  => null,
            'limit'    => 10,
            'null'     => false,
            'signed'   => false,
        ))
        ->addColumn('enable', 'boolean', array(
            'default' => null,
            'limit'   => null,
            'null'    => false,
        ))
        ->addColumn('title', 'string', array(
            'default' => null,
            'limit'   => 256,
            'null'    => false,
        ))
        ->addColumn('redirections', 'text', array(
            'comment' => '1 -> Direct, 2-> Counter Page',
            'default' => null,
            'limit'   => null,
            'null'    => false,
        ))
        ->addColumn('stats', 'integer', array(
            'comment' => 'no, simple, advanced',
            'default' => null,
            'limit'   => 2,
            'null'    => false,
        ))
        ->addColumn('api', 'boolean', array(
            'default' => null,
            'limit'   => null,
            'null'    => false,
        ))
        ->addColumn('timer', 'boolean', array(
            'default' => null,
            'limit'   => null,
            'null'    => false,
        ))
        ->addColumn('comments', 'boolean', array(
            'default' => null,
            'limit'   => null,
            'null'    => false,
        ))
        ->addColumn('sharing', 'boolean', array(
            'default' => null,
            'limit'   => null,
            'null'    => false,
        ))
        ->addColumn('feed', 'boolean', array(
            'default' => null,
            'limit'   => null,
            'null'    => false,
        ))
        ->addColumn('ads_area1', 'boolean', array(
            'default' => null,
            'limit'   => null,
            'null'    => false,
        ))
        ->addColumn('ads_area2', 'boolean', array(
            'default' => null,
            'limit'   => null,
            'null'    => false,
        ))
        ->addColumn('updated', 'datetime', array(
            'default' => null,
            'limit'   => null,
            'null'    => false,
        ))
        ->addColumn('created', 'datetime', array(
            'default' => null,
            'limit'   => null,
            'null'    => false,
        ))
        ->create();

        $table = $this->table('stats', array( 'id' => false, 'primary_key' => 'id' ));
        $table
        ->addColumn('id', 'integer', array(
            'identity' => true,
            'default'  => null,
            'limit'    => 10,
            'null'     => false,
            'signed'   => false,
        ))
        ->addColumn('link_id', 'integer', array(
            'default' => null,
            'limit'   => 10,
            'null'    => false,
            'signed'  => false,
        ))
        ->addColumn('user_id', 'integer', array(
            'default' => null,
            'limit'   => 10,
            'null'    => false,
            'signed'  => false,
        ))
        ->addColumn('ip', 'string', array(
            'default' => null,
            'limit'   => 256,
            'null'    => false,
        ))
        ->addColumn('continent', 'string', array(
            'default' => null,
            'limit'   => 256,
            'null'    => false,
        ))
        ->addColumn('country', 'string', array(
            'default' => null,
            'limit'   => 256,
            'null'    => false,
        ))
        ->addColumn('state', 'string', array(
            'default' => null,
            'limit'   => 256,
            'null'    => false,
        ))
        ->addColumn('city', 'string', array(
            'default' => null,
            'limit'   => 256,
            'null'    => false,
        ))
        ->addColumn('location', 'string', array(
            'default' => null,
            'limit'   => 256,
            'null'    => false,
        ))
        ->addColumn('browser', 'string', array(
            'default' => null,
            'limit'   => 256,
            'null'    => false,
        ))
        ->addColumn('platform', 'string', array(
            'default' => null,
            'limit'   => 256,
            'null'    => false,
        ))
        ->addColumn('device_type', 'string', array(
            'default' => null,
            'limit'   => 256,
            'null'    => false,
        ))
        ->addColumn('device_brand', 'string', array(
            'default' => null,
            'limit'   => 256,
            'null'    => false,
        ))
        ->addColumn('device_name', 'string', array(
            'default' => null,
            'limit'   => 256,
            'null'    => false,
        ))
        ->addColumn('is_mobile', 'integer', array(
            'default' => null,
            'limit'   => 3,
            'null'    => false,
            'signed'  => false,
        ))
        ->addColumn('is_tablet', 'integer', array(
            'default' => null,
            'limit'   => 3,
            'null'    => false,
            'signed'  => false,
        ))
        ->addColumn('language', 'string', array(
            'default' => null,
            'limit'   => 256,
            'null'    => false,
        ))
        ->addColumn('timezone', 'string', array(
            'default' => null,
            'limit'   => 256,
            'null'    => false,
        ))
        ->addColumn('referer_domain', 'string', array(
            'default' => null,
            'limit'   => 256,
            'null'    => false,
        ))
        ->addColumn('referer', 'string', array(
            'default' => null,
            'limit'   => 256,
            'null'    => false,
        ))
        ->addColumn('user_agent', 'string', array(
            'default' => null,
            'limit'   => 256,
            'null'    => false,
        ))
        ->addColumn('created', 'datetime', array(
            'default' => null,
            'limit'   => null,
            'null'    => false,
        ))
        ->addIndex(
            array(
            'link_id',
            )
        )
        ->addIndex(
            array(
            'user_id',
            )
        )
        ->create();

        $table = $this->table('users', array( 'id' => false, 'primary_key' => 'id' ));
        $table
        ->addColumn('id', 'integer', array(
            'identity' => true,
            'default'  => null,
            'limit'    => 10,
            'null'     => false,
            'signed'   => false,
        ))
        ->addColumn('username', 'string', array(
            'default' => null,
            'limit'   => 50,
            'null'    => false,
        ))
        ->addColumn('status', 'text', array(
            'comment' => '\'Active\',\'Inactive\',\'Banned\'',
            'default' => null,
            'limit'   => null,
            'null'    => false,
        ))
        ->addColumn('account_type', 'text', array(
            'comment' => '\'Free\',\'admin\'',
            'default' => null,
            'limit'   => null,
            'null'    => false,
        ))
        ->addColumn('plan_id', 'integer', array(
            'default' => null,
            'limit'   => 10,
            'null'    => false,
        ))
        ->addColumn('password', 'string', array(
            'default' => null,
            'limit'   => 256,
            'null'    => false,
        ))
        ->addColumn('first_name', 'string', array(
            'default' => null,
            'limit'   => 100,
            'null'    => false,
        ))
        ->addColumn('last_name', 'string', array(
            'default' => null,
            'limit'   => 100,
            'null'    => false,
        ))
        ->addColumn('email', 'string', array(
            'default' => null,
            'limit'   => 256,
            'null'    => false,
        ))
        ->addColumn('temp_email', 'string', array(
            'default' => null,
            'limit'   => 256,
            'null'    => false,
        ))
        ->addColumn('change_email_key', 'string', array(
            'default' => null,
            'limit'   => 256,
            'null'    => false,
        ))
        ->addColumn('links', 'integer', array(
            'default' => null,
            'limit'   => 10,
            'null'    => false,
            'signed'  => false,
        ))
        ->addColumn('country', 'string', array(
            'default' => null,
            'limit'   => 2,
            'null'    => false,
        ))
        ->addColumn('timer', 'integer', array(
            'default' => null,
            'limit'   => 3,
            'null'    => false,
            'signed'  => false,
        ))
        ->addColumn('feed', 'string', array(
            'default' => null,
            'limit'   => 256,
            'null'    => false,
        ))
        ->addColumn('redirection_type', 'integer', array(
            'default' => null,
            'limit'   => 2,
            'null'    => false,
            'signed'  => false,
        ))
        ->addColumn('disqus_shortname', 'string', array(
            'default' => null,
            'limit'   => 256,
            'null'    => false,
        ))
        ->addColumn('sharing', 'boolean', array(
            'default' => null,
            'limit'   => null,
            'null'    => false,
        ))
        ->addColumn('api_key', 'string', array(
            'default' => null,
            'limit'   => 256,
            'null'    => false,
        ))
        ->addColumn('last_bundle_id', 'integer', array(
            'default' => null,
            'limit'   => 10,
            'null'    => false,
            'signed'  => false,
        ))
        ->addColumn('user_activation_key', 'string', array(
            'default' => null,
            'limit'   => 256,
            'null'    => false,
        ))
        ->addColumn('login_ip', 'string', array(
            'default' => null,
            'limit'   => 256,
            'null'    => false,
        ))
        ->addColumn('register_ip', 'string', array(
            'default' => null,
            'limit'   => 256,
            'null'    => false,
        ))
        ->addColumn('last_login', 'datetime', array(
            'default' => null,
            'limit'   => null,
            'null'    => false,
        ))
        ->addColumn('updated', 'datetime', array(
            'default' => null,
            'limit'   => null,
            'null'    => false,
        ))
        ->addColumn('created', 'datetime', array(
            'default' => null,
            'limit'   => null,
            'null'    => false,
        ))
        ->create();
    }

    public function down()
    {
        $this->dropTable('activities');
        $this->dropTable('ads');
        $this->dropTable('bundles');
        $this->dropTable('links');
        $this->dropTable('options');
        $this->dropTable('pages');
        $this->dropTable('plans');
        $this->dropTable('stats');
        $this->dropTable('users');
    }
}
